import React from "react";

export default function ResetPageIcon() {
  return (
    <svg
      width="329"
      height="307"
      viewBox="0 0 329 307"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className=" tradex-max-w-full"
    >
      <g clipPath="url(#clip0_1972_4503)">
        <path
          d="M80.5103 70.2884H28.0163C26.4612 70.2884 25.1992 69.0344 25.1992 67.485V39.5078C25.1992 23.5607 38.2353 10.5883 54.2606 10.5883C70.2914 10.5883 83.3274 23.5607 83.3274 39.5078V67.485C83.3274 69.0325 82.0672 70.2884 80.5103 70.2884ZM30.8335 64.6817H77.6932V39.5078C77.6932 26.6521 67.1849 16.195 54.2661 16.195C41.3418 16.195 30.8335 26.6521 30.8335 39.5078V64.6817Z"
          className=" tradex-fill-title"
        />
        <path
          d="M321.303 130.311L286.212 136.831C286.212 136.831 276.692 109.373 270.765 106.528C265.898 104.195 258.857 101.302 255.537 99.4158C253.991 98.5372 253.013 96.9314 252.941 95.1597C252.925 94.7076 252.965 94.2684 253.057 93.8509C253.646 91.1733 256.332 89.3306 259.178 89.9339L270.864 92.4237L270.86 92.4183C270.772 92.174 267.941 84.4001 268.149 80.4502C268.3 77.6723 270.697 75.4468 273.394 75.784C273.69 75.8168 273.991 75.8824 274.287 75.9845C275.205 76.2889 276.137 76.9086 277 77.9166C277 77.9166 276.705 70.7295 280.936 70.0569C282.739 69.7726 284.114 70.1608 285.094 70.7131C286.184 71.311 286.79 72.1002 286.975 72.3591L287.034 72.4502C287.034 72.4502 288.192 67.3064 291.523 67.239C295.066 67.1661 298.317 71.3164 298.317 71.3164C298.317 71.3164 300.411 68.1813 305.507 69.953C310.6 71.7302 314.306 79.6135 317.136 89.4636C319.966 99.3046 321.303 130.311 321.303 130.311Z"
          fill="white"
        />
        <path
          d="M286.212 137.391C285.976 137.391 285.76 137.243 285.681 137.014C282.415 127.594 275.043 109.204 270.522 107.033C268.656 106.138 266.436 105.147 264.289 104.188C260.708 102.588 257.327 101.076 255.261 99.9027C253.537 98.922 252.462 97.1576 252.383 95.1818C252.365 94.6823 252.409 94.1938 252.511 93.729C253.182 90.6814 256.224 88.7311 259.301 89.3855L270.006 91.6657C269.218 89.3563 267.419 83.6766 267.591 80.4194C267.676 78.8537 268.412 77.3845 269.608 76.3893C270.718 75.467 272.09 75.0551 273.469 75.2283C273.806 75.2665 274.147 75.3431 274.475 75.4543C275.174 75.6858 275.843 76.0667 276.469 76.5917C276.614 74.3497 277.351 70.0608 280.853 69.503C282.514 69.2406 284.076 69.4903 285.377 70.2248C285.976 70.5547 286.447 70.9357 286.796 71.2838C287.361 69.6634 288.762 66.7325 291.517 66.6778C291.552 66.6778 291.586 66.676 291.621 66.676C294.61 66.676 297.301 69.3098 298.329 70.4545C299.256 69.5486 301.576 67.9883 305.698 69.421C310.388 71.0578 314.308 77.5632 317.682 89.3071C320.496 99.1025 321.813 129.019 321.868 130.288C321.88 130.567 321.684 130.811 321.408 130.864L286.317 137.384C286.282 137.387 286.247 137.391 286.212 137.391ZM258.101 90.3788C255.988 90.3788 254.075 91.8389 253.608 93.9678C253.526 94.3415 253.491 94.7352 253.506 95.138C253.57 96.7238 254.433 98.1419 255.817 98.9275C257.836 100.074 261.351 101.645 264.749 103.164C266.903 104.126 269.13 105.121 271.009 106.022C276.72 108.763 285.269 132.459 286.584 136.19L320.717 129.848C320.53 125.866 319.18 98.6122 316.596 89.6133C313.376 78.4035 309.583 71.9637 305.322 70.4782C300.732 68.8815 298.864 71.5135 298.787 71.6265C298.686 71.7742 298.517 71.8671 298.338 71.8726C298.138 71.8926 297.984 71.7997 297.874 71.6593C297.843 71.6192 294.742 67.7222 291.535 67.7988C288.687 67.8553 287.595 72.5251 287.584 72.5707C287.535 72.7913 287.355 72.9608 287.132 72.999C286.905 73.0391 286.683 72.9389 286.56 72.7493L286.502 72.6582C286.324 72.4085 285.773 71.7213 284.824 71.2018C283.727 70.5821 282.448 70.3852 281.027 70.6076C277.341 71.1945 277.563 77.8256 277.565 77.8913C277.574 78.13 277.431 78.3488 277.208 78.4363C276.984 78.5238 276.73 78.46 276.574 78.2777C275.821 77.3991 274.993 76.8067 274.112 76.5151C273.856 76.4276 273.596 76.3693 273.332 76.3401C272.264 76.2052 271.194 76.5279 270.328 77.2478C269.37 78.0444 268.78 79.2219 268.714 80.4777C268.555 83.4798 270.321 89.267 271.388 92.2162C271.454 92.3875 271.434 92.5844 271.326 92.7393C271.196 92.9252 270.969 93.0182 270.747 92.9708L259.061 90.4809C258.741 90.4117 258.42 90.3788 258.101 90.3788Z"
          fill="#070000"
        />
        <path
          d="M278.662 102.414C273.971 100.015 270.87 92.4201 270.87 92.4201L270.866 92.4146C270.779 92.1704 267.947 84.3964 268.156 80.4465C268.306 77.6687 270.703 75.4431 273.4 75.7803C273.471 75.7913 273.542 75.7967 273.612 75.8113C273.841 75.846 274.068 75.9061 274.293 75.9808C275.211 76.2852 276.143 76.905 277.006 77.9129C277.006 77.9129 277.186 81.5493 278.851 87.7685C280.463 93.7981 284.421 98.2893 284.664 98.5664C284.668 98.5718 284.672 98.5791 284.677 98.5791C286.311 102.487 283.347 104.813 278.662 102.414Z"
          fill="white"
        />
        <path
          d="M282.139 103.947C281.029 103.947 279.748 103.601 278.402 102.914C273.669 100.493 270.588 93.2221 270.355 92.657C270.346 92.6406 270.339 92.6224 270.333 92.606C270.029 91.7657 267.383 84.3381 267.59 80.4192C267.674 78.8534 268.41 77.3843 269.606 76.3891C270.716 75.4668 272.088 75.0549 273.467 75.228L273.537 75.2371C273.603 75.2444 273.667 75.2535 273.731 75.2681C273.938 75.2973 274.191 75.3592 274.469 75.454C275.546 75.8113 276.545 76.5167 277.431 77.5538C277.512 77.6486 277.559 77.7671 277.565 77.8892C277.567 77.9257 277.765 81.5511 279.391 87.6281C280.882 93.202 284.379 97.3961 285.077 98.1909C285.126 98.2419 285.166 98.3002 285.194 98.3677C286.007 100.311 285.824 102.02 284.69 103.061C284.045 103.652 283.164 103.947 282.139 103.947ZM271.381 92.194C271.385 92.1995 271.387 92.205 271.389 92.2105C271.42 92.2852 274.469 99.6418 278.917 101.917C281.036 103.001 282.957 103.125 283.926 102.234C284.677 101.545 284.771 100.325 284.188 98.8817C283.368 97.9357 279.829 93.6213 278.303 87.9143C276.84 82.4442 276.514 78.9865 276.453 78.1407C275.733 77.3387 274.947 76.7919 274.112 76.5167C273.896 76.4438 273.704 76.3964 273.526 76.369C273.458 76.3545 273.429 76.3526 273.398 76.349L273.314 76.3381C272.257 76.2068 271.194 76.5294 270.328 77.2494C269.37 78.046 268.78 79.2235 268.714 80.4793C268.557 83.4723 270.312 89.2376 271.381 92.194Z"
          fill="#070000"
        />
        <path
          d="M284.675 98.5791C284.67 98.5773 284.666 98.5718 284.663 98.5664C284.419 98.2893 280.463 93.7981 278.849 87.7685C277.184 81.5511 277.004 77.9129 277.004 77.9129C277.004 77.9129 276.71 70.7259 280.941 70.0533C282.743 69.7689 284.119 70.1572 285.099 70.7095C285.234 70.786 285.364 70.8608 285.489 70.941C285.611 71.0248 285.734 71.1087 285.846 71.1962C285.89 71.2326 285.939 71.2691 285.98 71.3037C286.082 71.3839 286.174 71.4659 286.256 71.5461C286.3 71.5826 286.339 71.6208 286.377 71.6609C286.688 71.9635 286.886 72.226 286.98 72.3554L287.038 72.4465C287.038 72.4465 285.11 86.4689 290.942 93.0216C292.092 94.3158 292.856 95.5406 293.275 96.627C294.986 101.034 291.072 103.18 284.675 98.5791Z"
          fill="white"
        />
        <path
          d="M290.864 101.722C289.08 101.722 286.801 100.801 284.343 99.033L284.345 99.0312C284.303 99.002 284.264 98.9674 284.231 98.9291C283.501 98.0943 279.857 93.7252 278.302 87.9125C276.641 81.7079 276.447 78.0916 276.439 77.9403C276.427 77.6213 276.179 70.2428 280.848 69.4992C282.51 69.2367 284.072 69.4864 285.373 70.221C285.515 70.3012 285.655 70.3832 285.787 70.467C285.935 70.5691 286.067 70.6603 286.188 70.7532C286.274 70.8207 286.314 70.8516 286.349 70.8845C286.437 70.9501 286.538 71.0394 286.629 71.1305C286.68 71.1724 286.726 71.2198 286.77 71.2654C287.016 71.5042 287.246 71.7703 287.433 72.031L287.508 72.1458C287.58 72.2588 287.609 72.3919 287.593 72.5231C287.572 72.6598 285.768 86.3686 291.358 92.6498C292.505 93.9384 293.326 95.2089 293.796 96.4246C294.573 98.4242 294.322 100.105 293.11 101.034C292.511 101.496 291.749 101.722 290.864 101.722ZM285.054 98.1599C288.856 100.879 291.401 100.932 292.425 100.147C293.214 99.5415 293.331 98.3312 292.747 96.8275C292.331 95.7521 291.558 94.5636 290.516 93.3916C284.913 87.0941 286.219 74.4588 286.45 72.5851C286.323 72.4174 286.158 72.2333 285.981 72.0619C285.944 72.0255 285.924 72.0036 285.9 71.9836C285.885 71.9708 285.869 71.958 285.856 71.9435C285.79 71.8778 285.715 71.8104 285.633 71.7466L285.539 71.6719C285.537 71.67 285.492 71.6354 285.492 71.6336C285.395 71.557 285.281 71.4805 285.166 71.4021C285.067 71.3401 284.946 71.269 284.819 71.198C283.728 70.5801 282.451 70.3832 281.028 70.6074C277.335 71.1961 277.564 77.8236 277.566 77.8911C277.568 77.922 277.766 81.5493 279.392 87.6245C280.867 93.1364 284.305 97.2996 285.054 98.1599Z"
          fill="#070000"
        />
        <path
          d="M300.149 95.9453C299.424 97.3561 297.643 98.59 293.276 96.627C292.855 95.5388 292.093 94.3139 290.943 93.0216C285.113 86.4688 287.04 72.4465 287.04 72.4465C287.04 72.4465 288.197 67.3028 291.529 67.2353C295.071 67.1624 298.323 71.3128 298.323 71.3128C298.323 71.3128 294.894 74.2255 296.203 80.9441C297.191 86.0022 299.202 90.6757 300.143 92.6844C300.623 93.7179 300.665 94.9263 300.149 95.9453Z"
          fill="white"
        />
        <path
          d="M297.187 98.2128C296.114 98.2128 294.758 97.9084 293.042 97.1355C292.906 97.0754 292.802 96.9642 292.749 96.8257C292.333 95.7502 291.562 94.5618 290.518 93.3898C284.585 86.7222 286.398 72.9496 286.479 72.3663C286.539 72.0929 287.785 66.7468 291.516 66.6721C291.551 66.6721 291.586 66.6703 291.62 66.6703C295.359 66.6703 298.628 70.7879 298.766 70.9647C298.951 71.2016 298.918 71.5406 298.687 71.7357C298.559 71.845 295.531 74.5536 296.755 80.8348C297.749 85.9312 299.812 90.652 300.652 92.4438C301.231 93.6887 301.229 95.054 300.651 96.1932C300.651 96.1932 300.651 96.195 300.649 96.195C300.116 97.2358 299.105 98.2128 297.187 98.2128ZM293.712 96.2059C295.875 97.1446 298.581 97.7607 299.645 95.6901C300.061 94.8699 300.055 93.8345 299.63 92.9195C298.773 91.0895 296.667 86.2684 295.648 81.0499C294.551 75.4158 296.643 72.3244 297.561 71.2855C296.691 70.3067 294.146 67.7603 291.538 67.7949C288.69 67.8514 287.598 72.5213 287.587 72.5668C287.576 72.658 285.772 86.365 291.362 92.6461C292.441 93.8619 293.231 95.0558 293.712 96.2059Z"
          fill="#070000"
        />
        <path
          d="M298.43 88.6106C298.43 88.6106 300.802 96.0127 304.731 95.1834C308.793 94.3249 305.657 89.3506 305.81 86.6329C305.962 83.9152 307.579 81.028 307.579 81.028"
          fill="white"
        />
        <path
          d="M304.106 95.8104C300.19 95.8104 297.987 89.0845 297.89 88.7819C297.796 88.4866 297.959 88.1713 298.256 88.0784C298.551 87.9836 298.87 88.1476 298.963 88.4411C299.58 90.3641 301.802 95.2308 304.61 94.6347C305.275 94.4944 305.72 94.2319 305.971 93.8327C306.546 92.9177 306.138 91.2918 305.744 89.7188C305.46 88.5887 305.192 87.5206 305.244 86.6019C305.401 83.7876 307.013 80.8767 307.083 80.7546C307.235 80.4848 307.575 80.3882 307.848 80.5377C308.12 80.689 308.218 81.0298 308.066 81.2996C308.052 81.3269 306.511 84.1103 306.368 86.6639C306.326 87.4112 306.575 88.401 306.837 89.4472C307.29 91.2463 307.755 93.1091 306.927 94.4269C306.511 95.0886 305.812 95.5279 304.844 95.732C304.594 95.7849 304.346 95.8104 304.106 95.8104Z"
          fill="#070000"
        />
        <path
          d="M210.07 158.307C210.07 158.307 226.762 159.145 235.802 160.306C252.93 162.508 278.463 189.716 278.463 189.716L276.633 125.596L328.435 122.315C328.435 122.315 335.269 214.024 297.476 230.053C262.436 244.914 216.238 198.161 216.238 198.161L210.07 158.307Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M278.463 190.277C278.159 190.277 277.91 190.037 277.9 189.732L276.071 125.612C276.061 125.31 276.296 125.056 276.598 125.036L328.402 121.753C328.709 121.733 328.979 121.968 329 122.277C329.021 122.585 328.784 122.853 328.475 122.873L277.215 126.121L279.031 189.7C279.04 190.009 278.794 190.268 278.483 190.276C278.474 190.277 278.468 190.277 278.463 190.277Z"
          fill="#070000"
        />
        <path
          d="M210.069 158.307C223.091 159.347 233.267 169.925 233.746 182.915L235.801 293.153C235.795 305.077 124.074 305.022 124.079 293.096L117.628 187.782C116.573 174.527 125.882 162.67 139.061 160.481C163.523 158.325 187.201 157.581 210.069 158.307Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M235.801 293.712C235.495 293.712 235.244 293.468 235.237 293.162L233.18 182.924C233.174 182.615 233.422 182.359 233.733 182.354C234.035 182.354 234.301 182.595 234.306 182.904L236.363 293.142C236.369 293.452 236.121 293.707 235.81 293.712C235.808 293.712 235.805 293.712 235.801 293.712Z"
          fill="#070000"
        />
        <path
          d="M151.666 198.389L157.419 253.027C157.684 255.544 159.98 257.352 162.504 257.033L187.14 253.904C189.42 253.614 191.122 251.673 191.1 249.385L190.594 195.294C190.57 192.665 188.301 190.613 185.667 190.841L155.785 193.423C153.257 193.642 151.402 195.879 151.666 198.389Z"
          fill="#070000"
        />
        <path
          d="M141.402 249.877L145.84 232.04L145.401 220.857C145.187 218.067 147.405 215.684 150.218 215.684C152.751 215.684 154.854 217.629 155.036 220.145C155.578 227.616 156.206 236.465 160.728 236.743C176.671 237.72 188.187 211.294 191.9 210.121C195.613 208.949 197.38 213.581 195.259 218.273C195.259 218.273 197.662 214.702 200.335 216.924C202.685 218.878 198.855 225.134 198.855 225.134C198.855 225.134 201.349 222.124 203.509 224.782C205.225 226.894 202.566 231.174 202.566 231.174C202.566 231.174 207.909 229.122 206.416 235.416C205.319 240.042 192.255 254.806 185.595 260.668C178.937 266.532 161.239 270.168 161.239 270.168L141.402 249.877Z"
          className=" tradex-fill-body"
        />
        <path
          d="M161.241 270.728C161.091 270.728 160.945 270.667 160.838 270.558L141 250.269C140.864 250.131 140.809 249.932 140.857 249.744L145.277 231.985L144.841 220.883C144.727 219.417 145.245 217.939 146.264 216.846C147.282 215.754 148.724 215.127 150.22 215.127C153.034 215.127 155.398 217.314 155.6 220.106L155.605 220.183C156.115 227.202 156.75 235.939 160.765 236.185C171.698 236.836 180.787 223.838 186.218 216.06C189.002 212.072 190.512 209.974 191.731 209.587C193.222 209.117 194.561 209.438 195.503 210.492C196.675 211.802 197.021 213.971 196.518 216.277C196.97 215.985 197.494 215.748 198.069 215.664C198.992 215.533 199.877 215.81 200.696 216.492C202.467 217.965 201.445 221.162 200.448 223.32C200.782 223.198 201.133 223.129 201.524 223.123C202.432 223.127 203.247 223.566 203.947 224.428C205.315 226.112 204.37 228.817 203.648 230.339C204.471 230.232 205.528 230.276 206.297 230.944C207.264 231.783 207.488 233.33 206.964 235.543C205.806 240.425 192.349 255.469 185.969 261.087C179.274 266.982 162.082 270.565 161.353 270.717C161.317 270.724 161.278 270.728 161.241 270.728ZM142.025 249.71L161.428 269.552C163.778 269.041 179.225 265.529 185.224 260.245C192.059 254.226 204.841 239.619 205.868 235.283C206.284 233.535 206.176 232.326 205.561 231.788C204.802 231.127 203.288 231.495 202.769 231.694C202.544 231.779 202.287 231.714 202.134 231.528C201.98 231.342 201.961 231.081 202.088 230.877C202.767 229.78 204.271 226.608 203.071 225.134C202.588 224.539 202.082 224.25 201.522 224.244C201.518 224.244 201.514 224.244 201.511 224.244C200.344 224.244 199.298 225.476 199.287 225.489C199.098 225.715 198.767 225.757 198.527 225.587C198.287 225.416 198.219 225.092 198.373 224.84C199.3 223.324 201.586 218.694 199.974 217.352C199.404 216.878 198.837 216.689 198.234 216.773C196.838 216.97 195.739 218.566 195.728 218.583C195.565 218.823 195.241 218.902 194.986 218.759C194.732 218.617 194.627 218.306 194.746 218.039C195.933 215.415 195.899 212.617 194.662 211.233C194.025 210.521 193.129 210.318 192.072 210.652C191.162 210.94 189.209 213.734 187.143 216.694C181.579 224.665 172.264 238.006 160.696 237.299C155.697 236.992 155.05 228.101 154.481 220.258L154.475 220.181C154.316 217.972 152.446 216.242 150.218 216.242C149.017 216.242 147.905 216.725 147.088 217.602C146.271 218.481 145.872 219.62 145.963 220.812L146.403 232.014C146.405 232.067 146.399 232.12 146.387 232.171L142.025 249.71Z"
          className=" tradex-fill-body"
        />
        <path
          d="M195.261 218.273C195.261 218.273 193.228 223.11 191.224 225.689C189.221 228.269 179.91 239.147 179.91 239.147"
          fill="white"
        />
        <path
          d="M179.91 239.708C179.78 239.708 179.652 239.664 179.546 239.575C179.309 239.375 179.28 239.021 179.482 238.784C179.575 238.677 188.807 227.888 190.779 225.347C192.714 222.857 194.721 218.103 194.741 218.056C194.86 217.77 195.192 217.635 195.479 217.755C195.767 217.874 195.903 218.204 195.782 218.49C195.697 218.69 193.697 223.426 191.671 226.034C189.682 228.595 180.722 239.067 180.341 239.511C180.227 239.641 180.07 239.708 179.91 239.708Z"
          fill="#070000"
        />
        <path
          d="M198.853 225.134C198.853 225.134 195.877 231.027 193.019 234.955C190.162 238.883 185.035 243.78 185.035 243.78"
          fill="white"
        />
        <path
          d="M185.036 244.34C184.888 244.34 184.739 244.281 184.629 244.167C184.415 243.942 184.421 243.589 184.646 243.374C184.697 243.325 189.769 238.467 192.564 234.625C195.363 230.777 198.321 224.939 198.35 224.878C198.49 224.601 198.827 224.488 199.107 224.629C199.385 224.767 199.497 225.104 199.358 225.382C199.329 225.44 196.328 231.36 193.478 235.281C190.623 239.205 185.639 243.981 185.428 244.181C185.318 244.289 185.177 244.34 185.036 244.34Z"
          fill="#070000"
        />
        <path
          d="M202.572 231.172C202.572 231.172 198.557 237.417 196.67 240.115C194.786 242.812 187.957 249.057 187.957 249.057"
          fill="white"
        />
        <path
          d="M187.957 249.618C187.805 249.618 187.653 249.558 187.543 249.438C187.333 249.21 187.347 248.855 187.576 248.645C187.644 248.583 194.379 242.411 196.207 239.796C198.065 237.138 202.056 230.934 202.096 230.872C202.265 230.611 202.613 230.534 202.874 230.702C203.136 230.87 203.213 231.216 203.045 231.477C203.005 231.539 199.002 237.762 197.132 240.437C195.233 243.153 188.619 249.216 188.338 249.473C188.23 249.569 188.093 249.618 187.957 249.618Z"
          fill="#070000"
        />
        <path
          d="M141.104 160.306C141.104 160.306 115.51 159.021 102.654 175.172C95.5906 184.045 36.1638 276.5 76.9405 299.72C117.717 322.94 172.398 273.998 172.398 273.998L138.401 238.914L104.991 261.958L134.453 193.219L141.104 160.306Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M101.451 306.479C92.3418 306.479 84.015 304.393 76.6626 300.207C76.3934 300.054 76.2981 299.711 76.4538 299.441C76.6077 299.173 76.952 299.078 77.2231 299.233C98.0694 311.105 122.711 303.519 139.711 295.065C156.348 286.791 169.102 276.106 171.586 273.963L138.328 239.644L105.31 262.418C105.105 262.56 104.828 262.549 104.634 262.392C104.44 262.234 104.374 261.967 104.471 261.738L133.934 193.001C134.056 192.716 134.388 192.585 134.674 192.705C134.959 192.827 135.093 193.157 134.97 193.442L106.275 260.391L138.081 238.454C138.306 238.299 138.615 238.328 138.808 238.525L172.807 273.609C172.914 273.719 172.97 273.866 172.965 274.018C172.959 274.171 172.892 274.313 172.778 274.415C172.641 274.539 158.835 286.81 140.214 296.069C126.275 302.999 113.212 306.479 101.451 306.479Z"
          fill="#070000"
        />
        <path
          d="M134.256 106.916C134.256 106.916 121.526 92.1831 128.376 83.6728C135.227 75.1624 147.351 83.4759 147.351 83.4759L143.019 98.6138L137.769 109.007"
          fill="#0A563B"
        />
        <path
          d="M146.045 104.131C146.045 104.131 136.397 94.2975 129.747 103.338C123.096 112.377 133.474 123.02 144.242 123.901"
          fill="#E2E2E2"
        />
        <path
          d="M144.244 124.46C144.23 124.46 144.213 124.46 144.197 124.458C137.421 123.904 130.672 119.513 128.149 114.018C126.426 110.261 126.83 106.349 129.292 103.005C131.126 100.511 133.36 99.1551 135.932 98.9746C141.332 98.5845 146.243 103.528 146.448 103.737C146.666 103.958 146.66 104.313 146.439 104.53C146.215 104.747 145.858 104.744 145.642 104.521C145.594 104.474 140.876 99.7511 136.007 100.092C133.784 100.251 131.829 101.452 130.201 103.666C127.369 107.516 128.08 111.167 129.173 113.551C131.536 118.7 137.894 122.816 144.288 123.339C144.598 123.365 144.829 123.636 144.803 123.944C144.781 124.24 144.534 124.46 144.244 124.46Z"
          fill="#070000"
        />
        <path
          d="M193.724 159.511C195.127 172.389 162.721 178.045 160.488 160.37L157.863 123.108L192.484 128.521L193.724 159.511Z"
          fill="#ECECEC"
        />
        <path
          d="M175.927 172.085C168.285 172.085 160.967 168.662 159.929 160.441L157.302 123.148C157.29 122.976 157.357 122.811 157.484 122.696C157.61 122.579 157.782 122.528 157.953 122.554L192.573 127.967C192.839 128.009 193.038 128.231 193.049 128.499L194.287 159.471C195.017 166.307 186.952 170.98 178.986 171.906C177.967 172.024 176.943 172.085 175.927 172.085ZM158.475 123.771L161.05 160.332C162.127 168.855 170.772 171.736 178.854 170.792C186.289 169.927 193.831 165.7 193.165 159.572C193.163 159.559 193.163 159.546 193.161 159.533L191.939 129.002L158.475 123.771Z"
          fill="#070000"
        />
        <path
          d="M181.858 147.235C179.601 148.077 177.229 148.637 174.768 148.867C155.711 150.644 138.372 132.008 136.504 112.173C134.636 92.338 148.946 78.8151 168.005 77.0398C187.062 75.2626 203.648 85.9038 205.516 105.739C206.575 116.974 202.682 128.749 195.645 137.17"
          fill="#ECECEC"
        />
        <path
          d="M172.211 149.546C163.902 149.546 155.674 145.87 148.791 139.02C141.55 131.815 136.868 122.049 135.942 112.226C134.141 93.1054 147.303 78.4069 167.95 76.4802C177.586 75.5853 186.67 77.8382 193.537 82.8306C200.83 88.1348 205.166 96.0382 206.075 105.686C207.128 116.872 203.389 128.776 196.075 137.529C195.878 137.766 195.522 137.799 195.282 137.602C195.042 137.405 195.011 137.052 195.209 136.813C202.336 128.284 205.979 116.688 204.952 105.792C204.074 96.4738 199.898 88.8475 192.872 83.7384C186.228 78.9063 177.414 76.7227 168.056 77.5994C148.071 79.4622 135.326 93.6595 137.064 112.122C138.814 130.699 155.291 150.126 174.714 148.309C177.072 148.09 179.407 147.552 181.66 146.71C181.951 146.603 182.276 146.747 182.385 147.038C182.494 147.328 182.347 147.651 182.056 147.76C179.709 148.635 177.275 149.197 174.819 149.424C173.952 149.506 173.081 149.546 172.211 149.546Z"
          fill="#070000"
        />
        <path
          d="M208.316 104.811C205.758 114.805 197.213 104.12 197.213 104.12C197.213 104.12 195.645 109.122 192.678 108.823C188.895 108.444 191.068 100.136 191.353 92.524C186.919 90.3367 183.29 86.6147 181.072 82.2073C180.358 83.6254 179.314 84.8594 177.984 85.7963C175.998 87.2089 173.698 88.1148 171.416 88.9751C165.704 91.1205 159.852 93.0489 153.782 93.7343C147.717 94.4142 141.371 93.7762 135.936 90.9983C130.507 88.215 126.115 83.1077 125.087 77.1146C124.319 72.6124 125.633 67.6254 129.085 64.6215C132.544 61.6122 138.207 61.1273 141.719 64.0619C143.547 58.0524 145.607 51.6855 150.479 47.6938C154.903 44.0774 160.931 43.0658 166.657 43.0239C179.041 42.9291 191.421 46.8516 201.47 54.0569C203.556 55.5479 205.574 57.2139 207.005 59.3392C208.43 61.4682 209.219 64.1257 208.657 66.6247C208.153 68.8648 206.406 70.8735 204.197 71.4221C206.261 72.9897 214.429 80.9223 208.316 104.811Z"
          fill="#0A563B"
        />
        <path
          d="M195.203 107.335C195.203 107.335 202.7 92.6661 210.793 99.9115C218.883 107.157 211.179 119.273 201.162 122.225"
          fill="#E2E2E2"
        />
        <path
          d="M201.162 122.785C200.918 122.785 200.695 122.626 200.622 122.384C200.534 122.087 200.704 121.775 201.003 121.688C206.945 119.936 212.136 114.794 213.348 109.463C213.909 106.996 213.856 103.409 210.417 100.331C208.725 98.816 206.939 98.2164 205.102 98.559C199.893 99.5214 195.748 107.512 195.707 107.593C195.566 107.868 195.226 107.979 194.949 107.839C194.672 107.698 194.561 107.361 194.702 107.086C194.881 106.736 199.138 98.5226 204.893 97.4581C207.093 97.0516 209.203 97.7388 211.17 99.4996C214.169 102.184 215.334 105.812 214.447 109.712C213.152 115.416 207.632 120.906 201.323 122.767C201.268 122.778 201.215 122.785 201.162 122.785Z"
          fill="#070000"
        />
        <path
          d="M203.258 105.431C204.952 105.732 206.454 106.949 207.095 108.54C207.734 110.132 207.493 112.044 206.474 113.425"
          fill="#ECECEC"
        />
        <path
          d="M206.473 113.985C206.358 113.985 206.241 113.95 206.142 113.877C205.891 113.695 205.836 113.343 206.021 113.094C206.924 111.867 207.14 110.161 206.572 108.748C206.004 107.336 204.665 106.249 203.16 105.983C202.854 105.928 202.651 105.637 202.704 105.332C202.757 105.028 203.048 104.822 203.358 104.878C205.237 105.212 206.909 106.568 207.618 108.331C208.327 110.093 208.058 112.222 206.929 113.755C206.818 113.905 206.647 113.985 206.473 113.985Z"
          fill="#070000"
        />
        <path
          d="M174.59 98.2966C175.779 97.4982 177.226 97.0863 178.62 97.1483C180.013 97.2102 181.347 97.7461 182.336 98.6429"
          fill="#070000"
        />
        <path
          d="M182.333 99.2043C182.198 99.2043 182.062 99.1569 181.954 99.0585C181.056 98.2456 179.862 97.7662 178.591 97.7097C177.305 97.6532 175.999 98.0268 174.902 98.7614C174.644 98.9346 174.294 98.8671 174.12 98.6101C173.946 98.3531 174.014 98.005 174.272 97.8318C175.567 96.9624 177.118 96.5285 178.64 96.5887C180.174 96.658 181.619 97.2394 182.71 98.2292C182.941 98.437 182.958 98.7924 182.747 99.0202C182.639 99.1424 182.487 99.2043 182.333 99.2043Z"
          fill="#070000"
        />
        <path
          d="M179.811 108.754C181.294 108.489 182.186 106.57 181.809 104.457C181.432 102.345 179.924 100.838 178.444 101.109C176.961 101.373 176.069 103.293 176.446 105.405C176.825 107.518 178.34 109.022 179.811 108.754Z"
          fill="#070000"
        />
        <path
          d="M148.223 103.973C149.411 103.174 150.858 102.762 152.252 102.824C153.646 102.886 154.98 103.422 155.969 104.319"
          fill="#070000"
        />
        <path
          d="M155.97 104.88C155.834 104.88 155.699 104.833 155.591 104.734C154.693 103.922 153.499 103.442 152.228 103.386C150.94 103.327 149.636 103.701 148.539 104.437C148.28 104.611 147.931 104.543 147.757 104.286C147.583 104.029 147.65 103.681 147.909 103.508C149.204 102.638 150.755 102.205 152.277 102.265C153.81 102.334 155.256 102.915 156.347 103.905C156.578 104.113 156.594 104.468 156.384 104.696C156.276 104.818 156.122 104.88 155.97 104.88Z"
          fill="#070000"
        />
        <path
          d="M153.447 114.43C154.931 114.165 155.823 112.246 155.446 110.133C155.068 108.021 153.561 106.513 152.081 106.785C150.597 107.049 149.705 108.969 150.083 111.081C150.462 113.194 151.977 114.698 153.447 114.43Z"
          fill="#070000"
        />
        <path
          d="M165.934 105.95C166.575 110.336 165.494 114.949 162.974 118.602C162.448 119.364 161.833 120.288 162.203 121.137C162.483 121.777 163.214 122.071 163.873 122.302C165.395 122.834 166.917 123.368 168.439 123.901"
          fill="#ECECEC"
        />
        <path
          d="M168.441 124.46C168.379 124.46 168.317 124.451 168.254 124.429L163.688 122.831C162.911 122.559 162.054 122.2 161.688 121.362C161.184 120.21 161.981 119.052 162.51 118.287C164.952 114.747 165.998 110.281 165.377 106.032C165.331 105.726 165.545 105.442 165.853 105.398C166.161 105.347 166.446 105.566 166.49 105.872C167.152 110.396 166.038 115.153 163.437 118.921C162.924 119.665 162.483 120.377 162.719 120.915C162.904 121.34 163.483 121.573 164.06 121.773L168.628 123.372C168.921 123.474 169.077 123.795 168.972 124.086C168.892 124.316 168.674 124.46 168.441 124.46Z"
          fill="#070000"
        />
        <path
          d="M170.544 136.64C169.159 136.64 167.773 136.43 166.45 136.007C166.154 135.912 165.991 135.597 166.086 135.302C166.181 135.006 166.496 134.846 166.795 134.939C169.756 135.889 173.068 135.665 175.878 134.325C178.686 132.985 180.935 130.559 182.049 127.665C182.161 127.377 182.485 127.233 182.776 127.342C183.067 127.453 183.212 127.778 183.1 128.066C181.884 131.222 179.428 133.873 176.363 135.335C174.554 136.2 172.548 136.64 170.544 136.64Z"
          fill="#070000"
        />
        <path
          d="M93.1393 62.9154V104.764C93.1393 111.934 87.2962 117.749 80.0904 117.749H28.4317C21.2259 117.749 15.3828 111.934 15.3828 104.764V62.9154C15.3828 55.7448 21.2259 49.9357 28.4317 49.9357H80.0922C87.298 49.9357 93.1393 55.7448 93.1393 62.9154Z"
          className=" tradex-fill-primary/60"
        />
        <path
          d="M93.1397 62.9154V104.764C93.1397 111.934 87.2966 117.749 80.0908 117.749H28.4321C22.0871 117.749 16.7973 113.241 15.625 107.264C18.0135 109.962 21.512 111.661 25.4116 111.661H35.0243C65.4539 111.661 90.1211 87.1141 90.1211 56.8329C90.1211 55.9744 90.0368 55.1396 89.8793 54.3267C91.9069 56.6142 93.1397 59.6181 93.1397 62.9154Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M80.0902 118.31H28.4315C20.9253 118.31 14.8203 112.233 14.8203 104.764V62.9155C14.8203 55.4495 20.9271 49.3762 28.4315 49.3762H80.0921C87.5983 49.3762 93.7051 55.4495 93.7051 62.9155V104.764C93.7032 112.233 87.5964 118.31 80.0902 118.31ZM28.4315 50.4971C21.5481 50.4971 15.9468 56.0674 15.9468 62.9155V104.764C15.9468 111.614 21.5481 117.187 28.4315 117.187H80.0921C86.9755 117.187 92.5768 111.614 92.5768 104.764V62.9155C92.5768 56.0674 86.9755 50.4971 80.0921 50.4971H28.4315Z"
          fill="#070000"
        />
        <path
          d="M54.2634 98.3458C46.1729 98.3458 39.5898 91.7949 39.5898 83.7457C39.5898 82.5081 40.5991 81.5037 41.8428 81.5037C43.0865 81.5037 44.0958 82.5081 44.0958 83.7457C44.0958 89.3233 48.6566 93.8619 54.2616 93.8619C55.5053 93.8619 56.5145 94.8662 56.5145 96.1038C56.5145 97.3415 55.5071 98.3458 54.2634 98.3458Z"
          fill="white"
        />
        <path
          d="M66.6834 85.9877C65.4397 85.9877 64.4305 84.9833 64.4305 83.7457C64.4305 78.1681 59.8696 73.6295 54.2647 73.6295C53.021 73.6295 52.0117 72.6252 52.0117 71.3875C52.0117 70.1499 53.021 69.1456 54.2647 69.1456C62.3552 69.1456 68.9364 75.6965 68.9364 83.7475C68.9364 84.9833 67.9271 85.9877 66.6834 85.9877Z"
          fill="white"
        />
        <path
          d="M54.863 77.7744C54.1706 77.7744 53.4874 77.4591 53.0459 76.8612L49.454 72.0072C49.1005 71.5279 48.9503 70.9282 49.0419 70.3413C49.1317 69.7525 49.4522 69.2239 49.9339 68.8721L54.8117 65.2996C55.8136 64.565 57.2258 64.7783 57.9622 65.7771C58.7003 66.7742 58.486 68.1795 57.4823 68.9122L54.4197 71.156L56.6745 74.2037C57.4127 75.2007 57.1984 76.606 56.1946 77.3388C55.7953 77.6322 55.3264 77.7744 54.863 77.7744Z"
          fill="white"
        />
        <path
          d="M51.2717 102.19C50.5793 102.19 49.8961 101.875 49.4547 101.277C48.7165 100.28 48.9308 98.8762 49.9346 98.1417L52.9971 95.8979L50.7423 92.8503C50.0042 91.8532 50.2185 90.4497 51.2222 89.7152C52.2242 88.9806 53.6346 89.1939 54.3727 90.1927L57.9628 95.0467C58.701 96.0437 58.4867 97.4472 57.4829 98.1818L52.6052 101.754C52.204 102.048 51.7369 102.19 51.2717 102.19Z"
          fill="white"
        />
        <path
          d="M326.161 60.0319H217.255C215.999 60.0319 214.98 59.0184 214.98 57.768V23.4732C214.98 22.2228 215.999 21.2094 217.255 21.2094H326.161C327.418 21.2094 328.436 22.2228 328.436 23.4732V57.7662C328.438 59.0184 327.418 60.0319 326.161 60.0319Z"
          className=" tradex-fill-primary/30"
        />
        <path
          d="M228.566 48.4921L231.007 42.5755L225.008 45.0052L223.84 40.7801L230.264 39.9343L225.168 35.9717L228.3 32.8548L232.229 37.9785L233.079 31.6391L237.272 32.7491L234.83 38.6657L240.829 36.236L241.995 40.4629L235.572 41.3087L240.667 45.2713L237.535 48.3882L233.606 43.2645L232.756 49.604L228.566 48.4921Z"
          fill="#070000"
        />
        <path
          d="M254.425 48.4921L256.867 42.5755L250.868 45.0052L249.699 40.7801L256.123 39.9343L251.027 35.9717L254.159 32.8548L258.088 37.9785L258.938 31.6391L263.131 32.7491L260.689 38.6657L266.688 36.236L267.855 40.4629L261.431 41.3087L266.527 45.2713L263.395 48.3882L259.466 43.2645L258.616 49.604L254.425 48.4921Z"
          fill="#070000"
        />
        <path
          d="M280.284 48.4921L282.726 42.5755L276.727 45.0052L275.559 40.7801L281.982 39.9343L276.887 35.9717L280.019 32.8548L283.948 37.9785L284.798 31.6391L288.99 32.7491L286.549 38.6657L292.547 36.236L293.714 40.4629L287.29 41.3087L292.386 45.2713L289.254 48.3882L285.325 43.2645L284.475 49.604L280.284 48.4921Z"
          fill="#070000"
        />
        <path
          d="M306.14 48.4921L308.581 42.5755L302.583 45.0052L301.414 40.7801L307.838 39.9343L302.742 35.9717L305.874 32.8548L309.803 37.9785L310.653 31.6391L314.846 32.7491L312.404 38.6657L318.403 36.236L319.57 40.4629L313.146 41.3087L318.242 45.2713L315.109 48.3882L311.181 43.2645L310.331 49.604L306.14 48.4921Z"
          fill="#070000"
        />
        <path
          d="M257.656 252.839L301.1 283.521L275.33 307L257.656 252.839Z"
          className=" tradex-fill-primary/60"
        />
        <path
          d="M255.085 260.531L261.652 281.334L252.898 280.481L255.085 260.531Z"
          fill="#D4E8E8"
        />
        <path
          d="M291.212 242.975L265.801 247.619L286.867 265.587L291.212 242.975Z"
          fill="white"
        />
        <path
          d="M286.866 266.147C286.734 266.147 286.602 266.1 286.499 266.012L265.432 248.044C265.267 247.903 265.197 247.681 265.254 247.471C265.311 247.263 265.483 247.105 265.697 247.067L291.108 242.424C291.295 242.393 291.48 242.45 291.61 242.581C291.74 242.712 291.799 242.9 291.764 243.08L287.419 265.691C287.381 265.888 287.241 266.049 287.051 266.116C286.992 266.136 286.928 266.147 286.866 266.147ZM267.062 247.958L286.494 264.532L290.5 243.674L267.062 247.958Z"
          fill="#070000"
        />
        <path
          d="M123.549 31.6208C123.547 31.6208 123.543 31.6208 123.541 31.6208C123.23 31.6172 122.981 31.362 122.984 31.054C123.06 25.3214 125.289 19.5689 129.104 15.2727C132.918 10.9765 138.38 8.06377 144.087 7.28546C149.055 6.60558 153.801 7.56252 157.447 9.97582C158.36 10.5792 159.193 11.2791 159.933 12.0501C165.891 6.65662 173.308 2.80335 181.16 1.07357C190.181 -0.915032 199.873 -0.125786 208.447 3.29731C208.736 3.41215 208.875 3.73842 208.76 4.02641C208.645 4.3144 208.317 4.45475 208.027 4.3381C199.662 0.998843 190.205 0.227825 181.404 2.16904C173.736 3.85872 166.494 7.62267 160.68 12.8922C162.801 15.4714 163.972 18.6849 163.805 21.8145C163.64 24.8767 161.662 28.143 158.636 28.3107C157.369 28.3873 156.141 27.8733 155.158 26.8817C153.921 25.6368 153.225 23.7885 153.343 22.0606C153.551 18.982 155.607 16.4356 157.374 14.5582C157.936 13.9622 158.517 13.3789 159.112 12.8138C158.431 12.1066 157.665 11.465 156.826 10.9091C153.409 8.64523 148.939 7.75391 144.243 8.39369C138.799 9.13736 133.59 11.9152 129.95 16.0146C126.313 20.1121 124.186 25.5985 124.115 31.0667C124.109 31.3748 123.856 31.6208 123.549 31.6208ZM159.856 13.6559C159.288 14.1973 158.733 14.755 158.195 15.3256C156.555 17.0644 154.65 19.4121 154.465 22.1353C154.37 23.5534 154.942 25.0681 155.958 26.0925C156.491 26.6302 157.372 27.2499 158.572 27.1898C160.968 27.0567 162.539 24.3208 162.679 21.7525C162.831 18.9236 161.774 16.0109 159.856 13.6559Z"
          className=" tradex-fill-title"
        />
      </g>
      <defs>
        <clipPath id="clip0_1972_4503">
          <rect width="329" height="307" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}
